<?php

$header = 'Agnostikerna Bildgalleri';
$row_count = 9;
$thumb_small_width = 40;
$thumb_small_height = 30;
$thumb_large_width = 60;
$thumb_large_height = 45;
$image_width = 400;
$image_height = 300;

$imagepath = realpath(dirname(__FILE__)).'/images';
$thumbpath = realpath(dirname(__FILE__)).'/thumbnails';

$images = scandir($imagepath);
$thumbs = scandir($thumbpath);

$filenames = array();

// get only images that exist both in $images and $thumbs
foreach($images as $image_name) {
  // skip directories
  if($image_name == '.' or $image_name == '..')
  {
    continue;
  }

  // skip all but jpg and png
  $arr = explode('.', $image_name);
  $extension = strtolower(end($arr));
  if($extension != 'jpg' and $extension != 'png')
  {
    continue;
  }


  if(in_array($image_name, $thumbs))
  {
    $image_name = character_fix($image_name);
    $filenames[] = $image_name;
  }
  
 
} 

// now get relative pathnames...
$scriptpath = realpath(dirname($_SERVER['SCRIPT_FILENAME']));
$scriptpath = str_replace($scriptpath, '', realpath(dirname(__FILE__)));
$scriptpath = str_replace('\\', '/', $scriptpath);
$scriptpath = substr($scriptpath, 1);

$imagepath = ($scriptpath == '') ? 'images' : $scriptpath.'/images';
$thumbpath = ($scriptpath == '') ? 'thumbnails' : $scriptpath.'/thumbnails';
$jspath = ($scriptpath == '') ? 'gallery.js' : $scriptpath.'/gallery.js';
?>
<script type="text/javascript">
// these is setup for 
var grow_width = '<?php echo $thumb_large_width ?>px';
var grow_height = '<?php echo $thumb_large_height ?>px';
</script>
<script type="text/javascript" src="<?php echo $jspath ?>"></script>

<h1><?php echo $header ?></h1>
<div id="image_place">
<?php if(count($filenames) == 0): ?>
  Inga bilder att visa.
<?php else: ?>
  <img id="image_showed" style="width:<?php echo $image_width ?>px;height:<?php echo $image_height ?>px;"src="<?php echo $imagepath.'/'.$filenames[0] ?>" alt="Stor bild" />
<?php endif; ?>
</div>
<div id="thumb_place">
<?php for($i = 0; $i < count($filenames); $i++): ?>
  <?php if(($i % $row_count) == 0): ?>
    <?php if($i > 0): ?>
      </div>
    <?php endif; ?>
    <?php if($i != count($filenames) -1): ?>
      <div>
    <?php endif; ?>
  <?php endif; ?>

        <img id="image_<?php echo $i ?>" src="<?php echo $thumbpath.'/'.$filenames[$i] ?>" alt="bild" style="width:<?php echo $thumb_small_width?>px;height:<?php echo $thumb_small_height?>px;" <?php echo mouse($i, $imagepath.'/'.$filenames[$i]) ?> />

<?php endfor; ?>
</div>


<?php

function mouse($index, $file) {
  $out = 'onmouseover="grow(';
  $out .= "'$index',";
  $out .= "'image_$index',";
  $out .= "'$file')\"";

  $out .= ' onmouseout="shrink(';
  $out .= "'$index',";
  $out .= "'image_$index',";
  $out .= "'$file')\"";

  $out .= ' onclick="show(';
  $out .= "'$index',";
  $out .= "'image_showed',";
  $out .= "'$file')\"";

  return $out;
}

function character_fix($string) {
  if( mb_detect_encoding($string) != 'UTF-8' )
  {
    return $string;
  }

  return (PHP_OS === 'WINNT') ? rawurlencode(utf8_encode($string)) : 
                                rawurlencode($string);
}
?>